; -*- Mode:Common-Lisp; Fonts:(MEDFNT HL12B HL12BI); Base:10 -*-
;1;;*
;1;;                           RESTRICTED RIGHTS LEGEND*

;1;;Use, duplication, or disclosure by the Government is subject to*
;1;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in*
;1;;Technical Data and Computer Software clause at 52.227-7013.*
;1;;*
;1;;                     TEXAS INSTRUMENTS INCORPORATED.*
;1;;                              P.O. BOX 2909*
;1;;                           AUSTIN, TEXAS 78769*
;1;;                                 MS 2151*
;1;;*
;1;; Copyright (C) 1984-1989 Texas Instruments Incorporated. All rights reserved.

;; Change History
;; Date         Person         Change
;;---------------------------------------------------------------------------
;; 04/21/87    KJF         If GWIN is not loaded, load it.  This prevents error if trying to load
;;                            GED without GWIN being previously loaded.  Bug #4853.
;; 03/12/87    KJF         Allow GED to be patchable.
;;



;;;
;;; The graphics editor requires the graphics window system so load it if is not already loaded.
;;;

(UNLESS (si:find-system-named 'gwin t t)
  (MAKE-SYSTEM 'gwin :noconfirm))


;;
;;First make sure that the graphics editor window system and the reference card
;;system definitions are loaded in.
;;


(defpackage "GED" (:size  1000)*
	1    (:use "LISP" "TICL" "W" "GWIN"))

(defsystem ged
  (:name "Graphics Editor")
  (:NICKNAMES*		1"Graphics-Editor")
  (:short-name "GED")
  (:pathname-default "sys:ged;")
  (:patchable        "sys:patch.ged;" patch)
  (:warnings-pathname-default "sys:cwarns;ged.lisp")
  (:module buffr     "ged-buffers")
  (:module build     ("build-command-tables" "reorder-menu"))
  (:module camera    "dunn-camera-driver")
  (:module chobj     "choose-object-values")
  (:module commands  ("mode-commands" "submenu-commands" "windowing-commands"*
		1     "status-commands" "function-commands" "picture-commands"*
		1     "presentation-commands" "subpicture-commands"
                     "mouse-move-commands"))
  (:module cursors   "cursor-defs")
  (:module defs      "definitions")
  (:module final     "compile-flavors")
  (:module flavors   ("graphics-editor-panes" "buffer-flavor"*
		1     "presentation-flavor" "graphics-editor-flavor"
                     "status-flavor"))
  (:module funcs     ("copy" "drag-copy" "delete" "move" "drag-move" "scale"*
		1     "edit-parameters" "rewindow" "paint"))
  (:module macros    "macros")
  (:module methods   ("buffer-object-methods" "buffer-methods" "ged-utility-methods"))
  (:module misc      ("misc" "SYSFIX"))
  (:module mouse     "mouse-command-tables")
  (:module objects   ("arc" "circle" "line" "polyline" "rectangle"*
		1     "spline" "text" "triangle" "subpicture" "ruler"))
  (:module patches   "patches-to-frames")
  (:module refcard   "ged-command-table")
  (:module aux*	1     ("sys:site;ged.system" "sys:site;graphics-editor.system"))*
	
1  (:auxiliary*	1      aux)
  (:compile-load      patches)
  (:compile-load      defs)
  (:compile-load      misc       (:fasload defs)*
		1                 (:fasload defs))
  (:compile-load      macros)
  (:compile-load      camera)
  (:compile-load      flavors    (:fasload defs misc)*
		1                 (:fasload defs misc))
  (:compile-load      chobj      (:fasload defs misc)*
		1                 (:fasload defs misc))
  (:compile-load      methods    (:fasload defs misc flavors chobj)*
		1                 (:fasload defs misc flavors chobj))
  (:compile-load-init commands (macros)*
		1                 (:fasload defs misc flavors chobj methods macros)
                                 (:fasload defs misc flavors chobj methods macros))
  (:compile-load      refcard    (:fasload defs misc flavors chobj methods macros commands)
                                 (:fasload defs misc flavors chobj methods macros commands))
  (:compile-load-init buffr   (macros)   (:fasload defs misc flavors macros)
                                         (:fasload defs misc flavors macros))
  (:compile-load      objects    (:fasload defs misc flavors chobj methods macros buffr)
                                 (:fasload defs misc flavors chobj methods macros buffr))
  (:compile-load       mouse     (:fasload defs misc flavors chobj methods macros buffr objects)
                                 (:fasload defs misc flavors chobj methods macros buffr objects))
  (:compile-load       funcs     (:fasload defs misc flavors chobj methods)
                                 (:fasload defs misc flavors chobj methods))
  (:compile-load       cursors   (:fasload defs misc flavors)*
		1                 (:fasload defs misc flavors))
  (:compile-load-init  build   (mouse)
                                 (:fasload defs misc flavors chobj methods macros buffr objects mouse commands)
                                 (:fasload defs misc flavors chobj methods macros buffr objects mouse commands))
  (:compile-load-init  final   (flavors methods buffr objects commands funcs)
                                 (:fasload defs misc flavors chobj methods macros buffr objects commands funcs)
                                 (:fasload defs misc flavors chobj methods macros buffr objects commands funcs))) 
